#include <stdio.h>
#include <stdint.h>

#define MAX 2048

int main() {
    int *p, n = 10, i;
    unsigned long rsp_before, rsp_after;

    // read current stack pointer
    asm volatile("movq %%rsp, %0" : "=r"(rsp_before));

    p = &n;
    printf("Address of n          : %p\n", (void *)p);
    printf("Stack pointer before  : %p\n", (void *)rsp_before);

    // push values to grow stack
    for (i = 0; i < MAX; ++i)
        asm volatile("pushq $10");

    // read new stack pointer
    asm volatile("movq %%rsp, %0" : "=r"(rsp_after));

    printf("Stack pointer after   : %p\n", (void *)rsp_after);
    
    //p = (int *) (((uintptr_t)p & 0xfffff000) - 0x00001000) ;
    //printf("p: %p\n", p) ;
    //*p = 20 ;     // Memory fault with original stack

	unsigned long bad_addr = rsp_after - 8;
	printf("Trying to write at:   %p\n", (void *)bad_addr);

	int *q = (int *)bad_addr;
	*q = 20;   // SEGFAULT

    return 0;
}
