% Matlab simulation for an unforced van der pol oscillator


% Author: Harish Dixit
% Date: 27 March 2014

% Department of Mechanical & Aerospace Engineering,
% Indian Institute of Technology Hyderabad

% Email: hdixit@iith.ac.in

% Van der pol oscillator
% x'' + epsilon*(x^2-1) x' + x = A sin(\omega t)



function ydot=vanderpol(t,y)

global epsilon A omega

ydot(1)=y(2);
ydot(2)=-epsilon* (y(1)^2-1)*y(2) - y(1) + A*sin(omega*t);

ydot = ydot';

end

